 /**************************************************************************//**
 * @file        uart_stdout.c
 * @version     V1.00.00
 * $Revision:   0 $
 * $Date:       2020-11-13 $
 * @brief       UART functions for retargetting
 *
 * @note
 *
 * Copyright (C) 2020 AMICCOM Electronics Corp. All rights reserved.
 *****************************************************************************/

#include "system_A9139M0.h"
#include "uart.h"


UART_Type* UartStdio;

/**
 *
 * @brief   Initial uart TX and set set IO altfuncset
 *
 * @param   *uart                   UART Pointer
 * @param   baudrate                baud rate
 *
 * @return  none
 */
void UartStdOutInit ( UART_Type *uart, Uint32 baudrate )
{
    UartStdio = uart;
    UART_init ( UartStdio, ( SystemCoreClock / baudrate ), 1, 0, 0, 0, 0, 0 );
    return;
}

/**
 *
 * @brief   Initial uart RX and set set IO altfuncset
 *
 * @param   *uart                   UART Pointer
 * @param   baudrate                baud rate
 *
 * @return  none
 */
void UartStdInInit ( UART_Type *uart, Uint32 baudrate )
{
    UartStdio = uart;
    UART_init ( UartStdio, ( SystemCoreClock / baudrate ), 0, 1, 0, 0, 0, 0 );
}

/**
 *
 * @brief   Initial uart RX/TX and set set IO altfuncset
 *
 * @param   *uart                   UART Pointer
 * @param   baudrate                baud rate
 *
 * @return  none
 */
void UartStdInOutInit ( UART_Type *uart, Uint32 baudrate )
{
    UartStdio = uart;
    UART_init ( UartStdio, ( SystemCoreClock / baudrate ), 1, 1, 0, 0, 0, 0 );
}

/**
 *
 * @brief   UartPutc for retarget.c
 *
 * @param   my_ch                   send char
 *
 * @return  none
 */
unsigned char UartPutc ( unsigned char my_ch )
{
    UART_SendChar ( UartStdio, my_ch );
    return ( my_ch );
}

/**
 *
 * @brief   Initial uart RX and set set IO altfuncset
 *
 * @param   *uart                   UART Pointer
 * @param   baudrate                baud rate
 *
 * @return  none
 */
unsigned char UartGetc ( void )
{
    return UART_ReceiveChar ( UartStdio );
}

/**
 *
 * @brief   UartEndSimulation for retarget.c
 *
 * @param   none
 *
 * @return  none
 */
void UartEndSimulation ( void )
{
    UartPutc ( (char) 0x4 ); // End of simulation
    while ( 1 );
}

